//-----------------------------------------------------------------------------------------------------------------------------
// PROJECT INCLUDE 
//-----------------------------------------------------------------------------------------------------------------------------
#include <stdio.h>
#include "XOP_Globals.h"
#include "XOP_Features.h"

#include "PCI-DIO-96-ML.h"

//#include <Dialogs.h>
//#include <Fonts.h>
//#include <MacWindows.h>
//#include <Menus.h>
//#include <QuickDraw.h>
//#include <TextEdit.h>

#ifdef CONNECTED_ON_VME
	#include <assert.h>	
	#include <string.h>
	#include <NameRegistry.h>
	#include <pci.h>
#endif 
//-----------------------------------------------------------------------------------------------------------------------------
// All structures are 2-byte-aligned.
#if TARGET_CPU_PPC
	#pragma options align=mac68k
#endif
#ifdef _WINDOWS_
	#pragma pack(2)
#endif

//-----------------------------------------------------------------------------------------------------------------------------
// MISC #DEFINEs
//-----------------------------------------------------------------------------------------------------------------------------
#pragma mark Defines

/* PPI A */
#define A_PORTA_ADDR  0x00	/* Port A */
#define A_PORTB_ADDR  0x01	/* Port B */
#define A_PORTC_ADDR  0x02	/* Port C */
#define A_CNFG_ADDR   0x03	/* Config Register */

/* PPI B if using PCI-DIO-96*/
#define B_PORTA_ADDR 0x04	/* PPI B Port A */
#define B_PORTB_ADDR 0x05	/* PPI B Port B */
#define B_PORTC_ADDR 0x06	/* PPI B Port C */
#define B_CNFG_ADDR  0x07	/* PPI B Config Port */

/* PPI C if using PCI-DIO-96*/
#define C_PORTA_ADDR 0x08	/* PPI C Port A */
#define C_PORTB_ADDR 0x09	/* PPI C Port B */
#define C_PORTC_ADDR 0x0A	/* PPI C Port C */
#define C_CNFG_ADDR  0x0B	/* PPI C Config Port */

/* PPI D if using PCI-DIO-96*/
#define D_PORTA_ADDR 0x0C	/* PPI D Port A */
#define D_PORTB_ADDR 0x0D	/* PPI D Port B */
#define D_PORTC_ADDR 0x0E	/* PPI D Port C */
#define D_CNFG_ADDR  0x0F	/* PPI D Config Port */

/* Counter/Timer */
#define CLOCKA       0x10	/* Clock or Counter 0 */
#define CLOCKB       0x11	/* Clock or Counter 1 */
#define CLOCKC       0x12	/* Clock or Counter 2 - Not used */
#define CLOCK_CTRL   0x13	/* Clock or Counter Control */

/* Interrupt control */
#define INTR_CTRL1   0x14	/* First interrupt control reg */
#define INTR_CTRL2   0x15	/* Second interrupt control reg */
#define INTR_CLEAR   0x16	/* Interrupt Clear Register */

//-----------------------------------------------------------------------------------------------------------------------------
//  									  CODE  
//-----------------------------------------------------------------------------------------------------------------------------
 int set_counter(unsigned int counter_number,  unsigned int count,  unsigned int mode)
{
    /* Taken from Frank Hess' code in the comedi library */
    unsigned char byte, *p;
    
    if (counter_number > 2) return -1;
    if (count > 0xffff) return -1;
    if (mode == 2 && count == 1) return -1;

    byte = counter_number << 6;
    byte |= 0x30;   /* load low then high byte */
    byte |= (mode << 1);  /* set counter mode */

    p= (unsigned char *) (cardBaseAddress + CLOCK_CTRL);
    * p = byte;

     byte = count & 0xff;   /* LSB of counter value */
    p= (unsigned char *) (cardBaseAddress  + CLOCKA + counter_number);
    * p = byte;

//     printf("LSB %d\n ",  byte);

     byte = (count >> 8) & 0xff;   /* MSB of counter value */
     p= (unsigned char *) (cardBaseAddress  + CLOCKA + counter_number);
    * p = byte;

//    printf("MSB %d\n ",  byte);

    return 0;

}
//-----------------------------------------------------------------------------------------------------------------------------
unsigned int read_counter(unsigned int counter_number)
{
    unsigned char byte;
    unsigned int counter_value;

    /* Latch counter */
    byte = (counter_number << 6); /* ##00 xxxx */
                                  /* ## = counter number in binary - 00, 01, 11 */
				  /* 00 = Perform latching */
				  /* xxxx "Not specified" */

//				  printf("Byte %d\n",  byte);

     * (char*)(cardBaseAddress+ CLOCK_CTRL) = byte;

    * (char*)(cardBaseAddress + CLOCKA + counter_number); /* LSB */
    counter_value = byte;
    byte =  * (char*)(cardBaseAddress + CLOCKA + counter_number); /* MSB */
    counter_value |= (byte << 8);

    return counter_value;

}

//-----------------------------------------------------------------------------------------------------------------------------
void wait_microseconds(int number)
{

  /* This function uses the 8253 counter on the NI PCI-DIO-96
   * board to pause the program a certain amount of time. The
   * time is on the order of microseconds (us),  but I can't be sure of
   * anything better than within 100 us.
   *
   * Roughly, <= 100 is about 30 us (since the clock isn't really used)
   *             200 is about 150-200 us
   *             500 is about 400-500 us
   *             1000 is about 920-940 us
   *             2000 is about 1.98-2 ms
   */
  register unsigned int counter_value;
  register unsigned int clock_number = 0;

  set_counter(clock_number, number, 2);  /* Set clock 0 to mode 2 */

  counter_value = read_counter(clock_number);
  /* From what I've seen in mode 2, the count will restart after it
   * reaches 0. With the time it takes to latch,  read the LSB and
   * MSB, and compare the counter value, we may miss 0. Therefore,
   * I'm saying that anything under a count of 100 is effectively 0.
   * This seems to work empirically when I look at it on the
   * oscilloscope. Ideally, I'd like to get a mode working that
   * will count down to 0 and stop counting.  GAR 6/11/01
   */

  while (counter_value > 100) {
    counter_value = read_counter(clock_number);
    }


}
//-----------------------------------------------------------------------------------------------------------------------------
static int Clean_The_VME_Buffer()
{
#ifdef CONNECTED_ON_VME
int er=0;
Byte c;
char C, *p;
long count;

	p=&C;
next:
	count=0;
wait:
 	*p=(*((Byte *) PORTC))& 0x02;  	/* Mac checking the BUSY line */
	count++;
	if (count>100) {goto exit;}   	/* time out ? */
	if (*p != 0x02) goto wait;			/* BUSY =0 : no data available yet */
		
	c = *((Byte *)PORTB );			/* tranfering one byte from VME to mac */
	goto next;
	
exit:
#endif
	return 0;
}

//-----------------------------------------------------------------------------------------------------------------------------
//	The idea is to separe the data read on the VME from the interpretation
//	A big bunch of data is transfered at once into a buffer in the Macintosh 
//  if acquisition is running ( acquisState == RUNNING ) it is stopped.
//  returns: 	nBytesRead before the BufferLength or a timeout
//  	 		ElapsedTicks during which the acquisition has been inhibited
static int transfer_a_whole_bunch(long BufferLength, char *Buffer)
{
int result=0;
#ifdef CONNECTED_ON_VME
long count, StartTime;
unsigned long NbBytesEcrits;

char C, *p, *q;
char s[255];

	acquisState = GetIgorNumVar("acquisState");
	nBytesRead=0; p = &C;q = Buffer;
	
	if (acquisState == RUNNING) {SUSPEND_ACQ2;	StartTime = TickCount();}
//	Loop starts here
next:
	count=0;
wait:
 	*p=(*((Byte *) PORTC))& 0x02;  	/* Mac checking the BUSY line */
	count++;
	if (count>100) {goto exit;}   	/* time out ? */
	if (*p != 0x02) goto wait;			/* BUSY =0 : no data available yet */
		
	*q++ = *((Byte *)PORTB );			/* tranfering one byte from VME to mac */
	nBytesRead++;
	if(nBytesRead<BufferLength) goto next;
	
exit:	

	if ((a_dump_file_is_defined == 1) &&(nBytesRead !=0)) {
		result = XOPWriteFile(ReadOrWriteFileRef, nBytesRead, Buffer, &NbBytesEcrits);
		if(result) XOPNotice("Problems writing the dump on file. Is the disk full?\015");
		if (nBytesRead!=NbBytesEcrits) XOPNotice("Bug while writing\r");
		}

	if (acquisState == RUNNING) {RESUME_ACQ;	ElapsedTicks = TickCount() - StartTime;}
	else ElapsedTicks=0;

	BytesFromVME+=nBytesRead;
	NumVMECycle+=1;
	if (nBytesRead!=0) {sprintf(s," From VME : %ld Bytes ",nBytesRead);	XOPNotice(s);XOPSilentCommand("print date(),time()");}

#endif
	return(result);
}
//-----------------------------------------------------------------------------------------------------------------------------
void GetNIDIO96BaseAdress()
{
#ifdef CONNECTED_ON_VME	
	/*
	Assume we're running native on ppc.
	*/
OSStatus 			error;
RegEntryIter 			cookie;
Boolean 				done;
RegEntryIterationOp	op;
RegEntryID 			entry;
RegCStrPathName 		*pathName;
RegPathNameSize 		pathNameSize;
RegPropertyNameBuf 	foundProperty;
RegPropertyValueSize 	propertySize;
long 				templong;
char 				*propertyValue[256];
//ML
RegEntryIDPtr			deviceNode;	
unsigned short 		pciCommandRegister;
unsigned long 			miteBaseAddress;


	deviceNode = &entry;
	
	error=Gestalt(gestaltNameRegistryVersion,&templong);
	if(error)return;	// No PCI slots
	// NameRegistryLib is weak-linked, and may be missing.
	if((Ptr)RegistryEntryIterate == (Ptr)kUnresolvedCFragSymbolAddress)return;

	op=kRegIterContinue;
	error=RegistryEntryIterateCreate(&cookie);
	if(!error){
		done=FALSE;
		while (!error && !done){
			error=RegistryEntryIterate(&cookie,op,&entry,&done);		// Return each value of the iteration
			if(!error && !done){
				pathName=NULL;
				error=RegistryEntryToPathSize(&entry,&pathNameSize);	// Convert an entry to a rooted name string
				if(!error){
					pathName=(RegCStrPathName *) NewPtr(pathNameSize);
					if(pathName==NULL)error=MemError();
				}
				if(!error){
					error=RegistryCStrEntryToPath(&entry,pathName,pathNameSize);
//					printf("%s\n",pathName);	// debugging
				}
				if(!error){
					propertySize=0;
	//----	
					strcpy(foundProperty,"name");			
					error=RegistryPropertyGetSize(&entry,foundProperty,&propertySize);	//Get the value of the specified property for the specified entry.
					if(!error)
					assert(propertySize<=sizeof(propertyValue));
					if(!error){
						/*
						 * (*propertySize) is the maximum size of the value returned in the buffer  pointed to by (propertyValue).  Upon return, (*propertySize) is the size of the
						 * value returned.
						 */
						error=RegistryPropertyGet(&entry,foundProperty,propertyValue,&propertySize);
						// Is it what we want?
//						printf("%s\n",propertyValue);	// debugging
						if(!error && strcmp("NATI,pci-dio-96",(char *)propertyValue)!=0)error=-1; // no
					}
					
					if(!error){

/*Bit 1, Memory Space Enable, is cleared to 0 for all devices before an operating system is loaded. Hence, the initialization routines of all run-time drivers
must set this bit to 1 if they wish to access their device in memory space. */
						// configure the i/o space of the board such that it is memory mapped.
						ExpMgrConfigReadWord(deviceNode, ((LogicalAddress) 0x00000004L), &pciCommandRegister);
						ExpMgrConfigWriteWord(deviceNode,((LogicalAddress) 0x00000004L),(pciCommandRegister | 0x0002));

						// get the base addresses for the board.
						ExpMgrConfigReadLong(deviceNode, ((LogicalAddress) 0x00000010L), &miteBaseAddress);
						ExpMgrConfigReadLong(deviceNode, ((LogicalAddress) 0x00000014L), &cardBaseAddress);
						// activate the standard i/o window.
						*((unsigned long *) (miteBaseAddress +0x000000c0L)) = EndianSwap32Bit(((cardBaseAddress &0xffffff00L) | 0x00000080L));
				//		return (cardBaseAddress);  // return the base address of the board.
					}
					error=0;
				}
				if(pathName != NULL)DisposePtr((Ptr) pathName);
				RegistryEntryIDDispose(&entry);
			}
		}
		RegistryEntryIterateDispose(&cookie);
	}
#endif
	return;
}	/* GetNIDIO96BaseAdress */

//-----------------------------------------------------------------------------------------------------------------------------
 void Init_8255()
{
#ifdef CONNECTED_ON_VME	

	unsigned long final_Tick;
	
		if(cardBaseAddress == 0)	GetNIDIO96BaseAdress();
		*((Byte *) (cardBaseAddress + CNFGoffset) ) =  0x86;
		Delay(1L,&final_Tick);
		SUSPEND_ACQ;
#endif
}

//-----------------------------------------------------------------------------------------------------------------------------
// All structures are 2-byte-aligned.
#if TARGET_CPU_PPC
	#pragma options align=reset
#endif
#ifdef _WINDOWS_
	#pragma pack()
#endif

